import sys
import socket
import requests
import json
from urllib.parse import urljoin
from colorama import Fore,Style,Back

headers = {
 "User-Agent":"Mozilla/5.0"
}

def get_users(url):
 print(Fore.RED+"Users: "+Fore.RESET)
 url_users = urljoin(url, "wp-json/wp/v2/users")
 r = requests.get(url=url_users, headers=headers)
 rt = json.loads(r.text)
 for i in rt:
  if "slug" in i:
   print(i["slug"])

def get_info(url, r_text_wp_json):
 jsons = json.loads(r_text_wp_json)
 if "name" in jsons:
  print(Fore.RED+"Blog Name: "+Fore.RESET+jsons["name"])
  print()
 if "description" in jsons:
  print(Fore.RED+"Blog Description: "+Fore.RESET+jsons["description"])
  print()
 get_users(url)
 print()
 if "namespaces" in jsons:
  jsons["namespaces"] = "\n".join(jsons["namespaces"])
  print(Fore.RED+"Namespaces:\n"+Fore.RESET+jsons["namespaces"])
  print()
 if "routes" in jsons:
  print(Fore.RED+"Routes:"+Fore.RESET)
  for route in jsons["routes"].keys():
   if not "_links" in jsons["routes"][route]: continue
   print(jsons["routes"][route]["_links"]["self"][0]["href"])
  print()

def main():
 if len(sys.argv) < 2:
  print("<url>")
  sys.exit(0)
 url = sys.argv[1]
 url_json = urljoin(url, "wp-json/")
 r_text_wp_json = requests.get(url=url_json, headers=headers).text
 get_info(url, r_text_wp_json)
 print()

if __name__ == "__main__":
 print(Style.BRIGHT, end="")
 main()
